/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching.ColorCalculators;

import BryceImages.ColorCalculators.RayMarching.BryceMath;
import BryceImages.ColorCalculators.RayMarching.Vector;
import BryceImages.Rendering.ColorCalculator;
import java.awt.Color;
import java.awt.Dimension;

public class ccFakePerlinNoise
extends ColorCalculator {
    Vector[][] v;
    int size = 30;

    public ccFakePerlinNoise(Dimension dim) {
        super(dim);
        this.iData();
    }

    public ccFakePerlinNoise(int width, int height) {
        super(width, height);
        this.iData();
    }

    private void iData() {
        BryceMath m = new BryceMath();
        m.random_set_seed(5);
        this.v = new Vector[this.room_width / this.size + 2][this.room_width / this.size + 2];
        int c = 0;
        while (c <= this.room_width / this.size + 1) {
            int r = 0;
            while (r <= this.room_height / this.size + 1) {
                this.v[c][r] = BryceMath.v(m.random(2) - 1.0, m.random(2) - 1.0, 0.0).norm();
                ++r;
            }
            ++c;
        }
        this.antiAliasing = 3;
    }

    @Override
    public Color getColor(double x, double y) {
        y += 3600.0;
        x = BryceMath.abs(x) % (double)this.room_width;
        y = BryceMath.abs(y) % (double)this.room_height;
        Vector z = BryceMath.v(x, y, 0.0);
        int xfactor = this.size;
        int yfactor = this.size;
        int x1 = (int)x / xfactor;
        int x2 = x1 + 1;
        int y1 = (int)y / yfactor;
        int y2 = y1 + 1;
        Vector v1 = this.v[x1][y1];
        Vector v2 = this.v[x2][y1];
        Vector v3 = this.v[x1][y2];
        Vector v4 = this.v[x2][y2];
        Vector d1 = BryceMath.v(x1 * xfactor, y1 * yfactor, 0.0).sub(z).norm();
        Vector d2 = BryceMath.v(x2 * xfactor, y1 * yfactor, 0.0).sub(z).norm();
        Vector d3 = BryceMath.v(x1 * xfactor, y2 * yfactor, 0.0).sub(z).norm();
        Vector d4 = BryceMath.v(x2 * xfactor, y2 * yfactor, 0.0).sub(z).norm();
        double s = d1.dot(v1);
        double t = d2.dot(v2);
        double u = d3.dot(v3);
        double v = d4.dot(v4);
        double xWeight = s + this.function(t - s) + u + this.function(v - u);
        double yWeight = s + this.function(u - s) + t + this.function(v - t);
        double val = (xWeight + yWeight) / 2.0;
        return ccFakePerlinNoise.Color_hsv(0.0, 0.0, 50.0 + 50.0 * BryceMath.cos(val));
    }

    double function(double in) {
        return 3.0 * BryceMath.sqr(in) - 2.0 * BryceMath.pow(in, 3);
    }
}

